import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;
import java.net.*;

/**
 * MultipleChoiceQuestions.java 1.0 22/12/12
 * <br><br>
 * Author       : James McMahon
 * <br>
 * Provides the editorpane where the html answer pages can be displayed
 * <br><br>
 * Created      : 22/12/2002
 * <br>
 * Last Updated : 22/12/2002
 */

public class AnswerPanel extends JPanel {

	private String url = "";//url string
	private URL codeBase = null;
	private URL answerURL = null;//the url of the answer page to be displayed
	private JEditorPane answerScreen= new JEditorPane(); //The Editor pane it is displayed upon
	private JScrollPane scroller = new JScrollPane(answerScreen);

	private JLabel defaultLabel = new JLabel("Solutions will appear here once you've pressed submit or reveal", JLabel.CENTER);
	private JLabel missingPageLabel;
	private JLabel missingPageNameLabel;
	
	/** 
	 * initlises the JEditorPane making it uneditable and 
	 * setting the page displayed to the default Label
	 * N.B. The webpages are not navigatable!
	 *
	 * @param codebase The applets codebase
	 */
	public AnswerPanel(URL codebase) {
		
		this.setLayout(new BorderLayout());
		this.setPreferredSize(new Dimension(180,180));
		this.setBorder(BorderFactory.createTitledBorder("Answers..."));
		codeBase = codebase;		
		
		answerScreen.setEditable(false);
		
		resetAnswerPanel();
	}//End constructor
	
	/** 
	 * sets the editorpane to show the page pointed to by the answerpage url 
	 * 
	 * @param pageName The name of the page that will be displayed (relative to the codebase)
	 */
	public void setAnswerPage(String pageName){
			
		try {
			removeAnswerPanelLabel();//in case one exists
			
			url = codeBase+pageName;
			answerURL = new URL(url);
			answerScreen.setPage(answerURL);
		

	this.add(scroller, BorderLayout.CENTER);	
	//		this.add(answerScreen, BorderLayout.CENTER);

		} catch(Exception ioe) { 
			//This is strange - if I catch the IOException that is supposed to be thrown then
			//it seems to ignore the actual exception that is generated - hence catch the general
			//case is the only why of ensuring that any problems will be caught
			
			//So got a problem here with trying to open the html page
			//So we will initilise the editor pane with an error message instead
		
			try {
				this.remove(answerScreen);
			}catch (NullPointerException npe){}

			this.add(missingPageLabel = new JLabel("An answer page appears to be missing. Please contact the Course Lecturer"),BorderLayout.NORTH);
			this.add(missingPageNameLabel = new JLabel("The missing page is :"+pageName),BorderLayout.CENTER);	
		}
		
		this.setVisible(true);
		this.answerScreen.setVisible(true);
		this.validate();
		this.repaint();
	}

	/** 
	 * Resets the answerPanel to display the default answer label
	 */
	public void resetAnswerPanel(){

		try {
			this.remove(scroller);
		}catch (NullPointerException npe) {/*not on the panel to start with so do nothing*/
		System.out.println("inside reset answer panel got null pointer");
		}
	
		this.add(defaultLabel, BorderLayout.CENTER);
	}
	
	/** 
	 * Removes all the labels if possible
	 */
	public void removeAnswerPanelLabel(){
		try {
			this.remove(defaultLabel);
			this.remove(missingPageLabel);
			this.remove(missingPageNameLabel);
		}catch (NullPointerException npe) {/*not on the panel to start with so do nothing*/}
	}	
}