import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

 /**
 * MultipleChoiceQuestions.java 1.0 22/12/12
 * <br><br>
 * Author       : James McMahon
 * <br><br>
 * Listens to the buttons on the menupanel and calls the correct function from the parent class
 * <br><br>
 * Created      : 22/12/2002
 * <br>
 * Last Updated : 22/12/2002
 */
 
public class MenuListener implements ActionListener {
	
	/**
	 * The parent class used to allow access to all of the necessary functions
	 */
	private MultipleChoiceQuestions parent;
	
	/**
	 * Sets up the listner by setting access to the main parent class
	 * @param parentOwner The main class that allows access to the necessary methods
	 */
	public MenuListener(MultipleChoiceQuestions parentOwner) {
		parent = parentOwner;
	}
	
	/**
	 * Deals with the action events generated by the buttons by calling 
	 * the necessary functions from the main parent class 
	 * @param ae The action event that has been generated by the user pressing a button
	 */
	public void actionPerformed(ActionEvent ae) {

		if (ae.getActionCommand().equals("QuestionSet")) {
			parent.selectQuestionSet();
		}
		else if (ae.getActionCommand().equals("Help")) { 
			new HelpPanel(parent);
		}	
		else if (ae.getActionCommand().equals("Hint")) {
			parent.showHint();
		}
		else if (ae.getActionCommand().equals("Reveal")) { 
			parent.showAnswer();
		}
		else if (ae.getActionCommand().equals("Submit")) {
			parent.checkAnswer();
		}
		else if (ae.getActionCommand().equals("Reset")) { 
			parent.resetAllPanels();
		}
		else if (ae.getActionCommand().equals("Refresh")) { 
			parent.validate();
			parent.repaint();
		}
	}
}