import java.awt.*;
import java.applet.*;
import javax.swing.*;

/**
 * MultipleChoiceQuestions.java 1.0 22/12/12
 * <br><br>
 * Author       : James McMahon
 * <br><br>
 * Provides the menu panel for the applet
 * <br><br>
 * Created      : 22/12/2002
 * <br>
 * Last Updated : 22/12/2002 
 */
 
public class MenuPanel extends JPanel {
		
	private JButton questionSet = new JButton("QuestionSet"); // Select a new Question Set
	private JButton help        = new JButton("Help");   // Display a help page
	private JButton hint		= new JButton("Hint");   // Show a hint
	private JButton reveal      = new JButton("Reveal"); // Reveal the answer and pass the question by
	private JButton submit	    = new JButton("Submit"); // Check if the user's answer is correct
	private JButton reset       = new JButton("Reset");  // Reset the screen's checkboxes and editorpanes
	private JButton refresh     = new JButton("Refresh");// Allows the screen to be refreshed if necessary
	
	private MenuListener mListener;
	private MultipleChoiceQuestions parent;
	
	/** 
	 * Constructor
	 * The parent is passed straight through to the listener so that it can simply call
	 * the relevant methods from the main class associated with each button
	 * 
	 * @param mqParent The parent that is passed through to the listener for all of the buttons
	 */
	public MenuPanel(MultipleChoiceQuestions mqParent) {
		
		parent=mqParent;
				
		this.setLayout(new FlowLayout());
		this.setBorder(BorderFactory.createEtchedBorder());
			
		addListeners(); //Add the MenuListener to all of the buttons
		
		//Add the tooltips to the buttons
		questionSet.setToolTipText("Select a new question set");
		help.setToolTipText("Displays a help page");
		hint.setToolTipText("Get a hint on the answer");
		reveal.setToolTipText("Displays the correct answer");
		submit.setToolTipText("Check if your answer is correct");
		reset.setToolTipText("Reset Screen");
		refresh.setToolTipText("Refresh the display");
			
		questionSet.setMnemonic('q');
		help.setMnemonic('h');
		hint.setMnemonic('i');
		reveal.setMnemonic('r');
		submit.setMnemonic('s');
		reset.setMnemonic('t');
		refresh.setMnemonic('f');	
			
		// Add the buttons to the panel
		this.add(questionSet);
		this.add(help);
		this.add(hint);
		this.add(reveal);
		this.add(submit);
		this.add(reset);
		this.add(refresh);
	}	
	
	/**
	 * Sets the listeners for each of the buttons
	 */
	private void addListeners() {
	
		mListener = new MenuListener(parent);
	
		questionSet.addActionListener(mListener); 
		help.addActionListener(mListener);     
		hint.addActionListener(mListener);
		reveal.addActionListener(mListener);
		submit.addActionListener(mListener);
		reset.addActionListener(mListener);
		refresh.addActionListener(mListener);
	}
}