 import java.util.*;
 import java.awt.*;
 import java.awt.event.*;
 import java.applet.*;
 import javax.swing.*;
 import javax.swing.event.*;
 
/**
 * MultipleChoiceQuestions.java 1.0 22/12/12
 * <br><br>
 * Author       : James McMahon
 * <br><br>
 * A class that provides encapsulation for the question set data that is held 
 * in each of the start up question set files
 * <br><br>
 * N.B. Based on the fact that there are only ever (and always) four possible checkboxes (later changed to radiobuttons)
 * <br><br>
 * Created      : 22/12/2002
 * <br>
 * Last Updated : 22/12/2002 
 */
 
 public class QuestionData {
 	
 	//These help out with identification of what to use when displaying
 	// the data for the checkboxes later
 	
 	/**
 	 * True if the checkboxes have textual descriptions
 	 */
 	private boolean checkBoxTextAvailable = false;
 	
 	/**
 	 * True if the checkboxes have images
 	 */
 	private boolean checkBoxImageAvailable = false;
 	
 	/** 
 	 * The text for the checkboxe 1 if it exists
 	 */
 	private String checkBoxText1 = null;
 	
  	/** 
 	 * The text for the checkboxe 2 if it exists
 	 */	
 	private String checkBoxText2 = null;
 	
  	/** 
 	 * The text for the checkboxe 3 if it exists
 	 */	
 	private String checkBoxText3 = null;
 	
  	/** 
 	 * The text for the checkboxe 4 if it exists
 	 */	
 	private String checkBoxText4 = null;
 	
 	/** 
 	 * The location of the image if it exists for checkbox 1 (Can be turned into URLs later)
 	 */
 	private ImageIcon checkBoxImage1 = null;
 	
 	/** 
 	 * The location of the image if it exists for checkbox 2 (Can be turned into URLs later)
 	 */ 	
 	private ImageIcon checkBoxImage2 = null;
 	
 	/** 
 	 * The location of the image if it exists for checkbox 3 (Can be turned into URLs later)
 	 */
 	private ImageIcon checkBoxImage3 = null;
 	
  	/** 
 	 * The location of the image if it exists for checkbox 4 (Can be turned into URLs later)
 	 */	
 	private ImageIcon checkBoxImage4 = null;
 	
 	/** 
 	 * The location of the answer files for textbox 1 (Can be turned into URLs later)
 	 */
 	private String checkBoxAnswerFile1 = null;
 	
  	/** 
 	 * The location of the answer files for textbox 2 (Can be turned into URLs later)
 	 */	
 	private String checkBoxAnswerFile2 = null;
 	
  	/** 
 	 * The location of the answer files for textbox 3 (Can be turned into URLs later)
 	 */	
 	private String checkBoxAnswerFile3 = null;
 	
  	/** 
 	 * The location of the answer files for textbox 4 (Can be turned into URLs later)
 	 */	
 	private String checkBoxAnswerFile4 = null;
 	
 	/** 
 	 * The box that contains the correct anwser - Default is undefined i.e. 0
 	 */
 	private int correctCheckBox = 0;
 	
 	/** 
 	 * The location of the question file that can be turned into a URL later
 	 */
 	private String questionFile = null;
 	
 	/** 
 	 * Everything exists with this constructor
 	 *
 	 * @param questionFileLocation The location of the question html page relative to the applet codebase
 	 * @param correctCheckbox The checkbox that represents the correct answer
 	 * @param checkboxImage1 The image for checkbox 1
 	 * @param checkboxImage2 The image for checkbox 2
 	 * @param checkboxImage3 The image for checkbox 3
 	 * @param checkboxImage4 The image for checkbox 4
 	 * @param checkboxText1 The text for checkbox 1
 	 * @param checkboxText2 The text for checkbox 2
 	 * @param checkboxText3 The text for checkbox 3
 	 * @param checkboxText4 The text for checkbox 4
 	 * @param checkbox1AnswerFile The location of the answer html page relative to the applet codebase for checkbox1
 	 * @param checkbox2AnswerFile The location of the answer html page relative to the applet codebase for checkbox2
 	 * @param checkbox3AnswerFile The location of the answer html page relative to the applet codebase for checkbox3
 	 * @param checkbox4AnswerFile The location of the answer html page relative to the applet codebase for checkbox4
 	 */
 	public QuestionData(String questionFileLocation,
						int correctCheckbox,
						ImageIcon checkboxImage1,
						ImageIcon checkboxImage2,
						ImageIcon checkboxImage3,
						ImageIcon checkboxImage4,
						String checkboxText1,
						String checkboxText2,
						String checkboxText3,
						String checkboxText4,
						String checkbox1AnswerFile,
						String checkbox2AnswerFile,
						String checkbox3AnswerFile,
						String checkbox4AnswerFile){	
 		
 		questionFile = questionFileLocation;
 	
 		correctCheckBox = correctCheckbox;
 	
 		//All possible elements exist with this constructor
 		checkBoxTextAvailable = true;
 		checkBoxImageAvailable = true;
 	
 	    //The text for the checkboxes (later changed to radiobuttons)
 		checkBoxText1 = checkboxText1;
 		checkBoxText2 = checkboxText2;
 		checkBoxText3 = checkboxText3;
 		checkBoxText4 = checkboxText4;
 	
 	    //The location of the images 
 	    checkBoxImage1 = checkboxImage1;
 	    checkBoxImage2 = checkboxImage2;
 	    checkBoxImage3 = checkboxImage3;
 	    checkBoxImage4 = checkboxImage4;
 	
 	    //The location of the answer files for each textbox
  	    checkBoxAnswerFile1 = checkbox1AnswerFile;
  	    checkBoxAnswerFile2 = checkbox2AnswerFile;
  	    checkBoxAnswerFile3 = checkbox3AnswerFile;
    	checkBoxAnswerFile4 = checkbox4AnswerFile;
 	}

  	/** 
 	 * This constructor has only a text component for the radiobuttons and no ImageIcons
 	 *
 	 * @param questionFileLocation The location of the question html page relative to the applet codebase
 	 * @param correctCheckbox The checkbox that represents the correct answer
 	 * @param checkboxText1 The text for checkbox 1
 	 * @param checkboxText2 The text for checkbox 2
 	 * @param checkboxText3 The text for checkbox 3
 	 * @param checkboxText4 The text for checkbox 4
 	 * @param checkbox1AnswerFile The location of the answer html page relative to the applet codebase for checkbox1
 	 * @param checkbox2AnswerFile The location of the answer html page relative to the applet codebase for checkbox2
 	 * @param checkbox3AnswerFile The location of the answer html page relative to the applet codebase for checkbox3
 	 * @param checkbox4AnswerFile The location of the answer html page relative to the applet codebase for checkbox4
 	 */
 	public QuestionData(String questionFileLocation,
						int correctCheckbox,
						String checkboxText1,
						String checkboxText2,
						String checkboxText3,
						String checkboxText4,
						String checkbox1AnswerFile,
						String checkbox2AnswerFile,
						String checkbox3AnswerFile,
						String checkbox4AnswerFile
 						){
 		
 		//The location of the html question file
 		questionFile = questionFileLocation;
 	
		//The answer that holds the correct location
 		correctCheckBox = correctCheckbox;
 	
 		checkBoxTextAvailable = true;
 		checkBoxImageAvailable = false;
 			
 		//The text for the checkboxes (later changed to radiobuttons)
 		checkBoxText1 = checkboxText1;
 		checkBoxText2 = checkboxText2;
 		checkBoxText3 = checkboxText3;
 		checkBoxText4 = checkboxText4;

 	    //The location of the answer files for each textbox
  	    checkBoxAnswerFile1 = checkbox1AnswerFile;
  	    checkBoxAnswerFile2 = checkbox2AnswerFile;
  	    checkBoxAnswerFile3 = checkbox3AnswerFile;
    	checkBoxAnswerFile4 = checkbox4AnswerFile;				
 	}
 
  	/** 
 	 * This constructor has only an image component for the radiobuttons and no text
 	 *
 	 * @param questionFileLocation The location of the question html page relative to the applet codebase
 	 * @param correctCheckbox The checkbox that represents the correct answer
 	 * @param checkboxImage1 The image for checkbox 1
 	 * @param checkboxImage2 The image for checkbox 2
 	 * @param checkboxImage3 The image for checkbox 3
 	 * @param checkboxImage4 The image for checkbox 4
 	 * @param checkbox1AnswerFile The location of the answer html page relative to the applet codebase for checkbox1
 	 * @param checkbox2AnswerFile The location of the answer html page relative to the applet codebase for checkbox2
 	 * @param checkbox3AnswerFile The location of the answer html page relative to the applet codebase for checkbox3
 	 * @param checkbox4AnswerFile The location of the answer html page relative to the applet codebase for checkbox4
 	 */
 	public QuestionData(String questionFileLocation,
						int correctCheckbox,
						ImageIcon checkboxImage1,
						ImageIcon checkboxImage2,
						ImageIcon checkboxImage3,
						ImageIcon checkboxImage4,
						String checkbox1AnswerFile,
						String checkbox2AnswerFile,
						String checkbox3AnswerFile,
						String checkbox4AnswerFile
 						){
 	
 		//The location of the html question file
 		questionFile = questionFileLocation;
 	
 		//The answer that holds the correct location
 		correctCheckBox = correctCheckbox;
 	
 		checkBoxTextAvailable = false;
 		checkBoxImageAvailable = true;
 		
 	    //The imageicons 
 	   	checkBoxImage1 = checkboxImage1;
 	    checkBoxImage2 = checkboxImage2;
 	    checkBoxImage3 = checkboxImage3;
 	   	checkBoxImage4 = checkboxImage4;
 	
 	    //The location of the answer files for each textbox
  	    checkBoxAnswerFile1 = checkbox1AnswerFile;
  	    checkBoxAnswerFile2 = checkbox2AnswerFile;
  	    checkBoxAnswerFile3 = checkbox3AnswerFile;
    	checkBoxAnswerFile4 = checkbox4AnswerFile;			
 	}
 	
 	/** 
 	 * Helper function for randomiseAnswerLocations()<br>
 	 * Returns a randomised version of originalVector.<br>
 	 * This also sets the location of the correct checkbox when it is changed
 	 * from the one supplied.
 	 * 
 	 * @param originalVector The vector containing all of the question data that is to be randomised
 	 * @return Vector The original vector with randomised contents
 	 */
  	private Vector randomiseVector(Vector originalVector){
		
		int counter = 1;//this will become the new correct checkbox location
 		Vector randomOrder = new Vector();
 		Random randNum = new Random();
 		
 		while(originalVector.size() != 0) {
 			//Get a random int between 0,1,2 - (size-1)
 			int takeFromLocation = randNum.nextInt(originalVector.size());
 	        
 	        String correctAnswer = (String) ((Vector)originalVector.elementAt(takeFromLocation)).elementAt(3);
 	     
 	     //Very unsatisfactory method of doing this just now
 	     //problem arises because vectors turn elements into
 	     //objects and a boolean isn't an object Boolean is
 	     //However it is complicated to retrieve it from the Vector
 	     //so this method needs to suffice for just now...could be changed later   	
 			if (correctAnswer.equals("true")) {
 				this.correctCheckBox = counter;	
 			}
 								
			randomOrder.addElement(originalVector.elementAt(takeFromLocation));
			originalVector.removeElementAt(takeFromLocation);
			counter++;
		}
 		return randomOrder;
 	}
 	
 	/** 
 	 * Randomises the location of the answer elements of this questiondata object
 	 */
 	public void randomiseAnswerLocations(){

 		//the four possible answers that contains a vector inside that 
 		//encapsulates all the various parts for one possible answer 
 		Vector possibleAnswers = new Vector(4);
 		int correctAnswerLocation = this.correctCheckBox;
 		
 		for(int i=1; i <= 4; i++) {
 			Vector temp = new Vector();
 		
 			temp.addElement(getCheckBoxText(i));
 			temp.addElement(getCheckBoxImage(i));
 			temp.addElement(getCheckBoxAnswerFile(i));
 			
 			if (correctAnswerLocation == i) {
 				temp.addElement("true");
 			}
 			else {
 				temp.addElement("false");
 			}
 			
 			possibleAnswers.addElement(temp);
 		}
 		
 		//Now have all of the parts of the question answers together
 		//randomise the possibleAnswers vector
 		Vector randomAnswerLocations = randomiseVector(possibleAnswers);
 		
 		//now we need to reset the question data to the items in the randomised Vector
 		
 		for(int i=0; i < randomAnswerLocations.size(); i++) {
 			Vector temp = new Vector();
 			temp = (Vector) randomAnswerLocations.elementAt(i);
 			
 			setCheckBoxText((i+1), ((String) temp.elementAt(0)));
 			setCheckBoxImage((i+1), ((ImageIcon) temp.elementAt(1)));
 			setCheckBoxAnswerFile((i+1), ((String) temp.elementAt(2)));
 		}
 	}
 	
 	/** 
 	 * Returns whether this questions checkbox has images
 	 *
 	 * @return false if there are no checkbox images
 	 * @return true if there are checkbox images
 	 */
 	public boolean hasImages(){
 		return this.checkBoxImageAvailable;
 	}
 	
 	/** 
 	 * Returns whether this questions checkbox has text
 	 *
 	 * @return false if there are no checkbox textual descriptions
 	 * @return true if there are checkbox textual descriptions
 	 */
  	public boolean hasText(){
 		return this.checkBoxTextAvailable;
 	}
 	
 	/** 
 	 * Returns the correct checkbox answer for this question
 	 * 
 	 * @return int in the range 1 to 4 (0 is default and means undefined) indicating the correct answer location
 	 */
 	public int getCorrectAnswerLocation(){
 		return this.correctCheckBox;
 	} 
 	
 	/** 
 	 * returns an array of three ints representing the locations of all wrong answers
 	 * 
 	 * @return Vector containing the three locations of the incorrect checkbox locations
 	 */
 	public Vector getWrongAnswerLocations() {
 		Vector wrongAnswers = new Vector(3);
 		
 		//loop through all of the checkbox locations and add them to
 		//the vector if it isn't the correctAnswer location
 		for(int i=1;i<=4;i++) {
 			if (i!=this.correctCheckBox) { 
 				wrongAnswers.addElement(new Integer(i));
 			}
 		}
 		
 		return wrongAnswers;
 	}
 	
 	/** 
 	 * Returns the question file location
 	 * 
 	 * @return The location of the question html file relative to the applets codebase
 	 */
 	public String getQuestionFileLocation(){
 		return this.questionFile;
 	}
 		
 	/** 
 	 * Returns a vector containing String representations 
 	 * of all of the answer file locations. <br>
 	 * The first item is the first location, etc.
 	 * 
 	 * @return Vector containing the locations of the html answer pages relative to the applets codebase
 	 */
 	public Vector getAllAnswerFileLocations(){
 		
 		Vector answerFiles = new Vector(4);
 		
 		answerFiles.addElement(this.checkBoxAnswerFile1);
 		answerFiles.addElement(this.checkBoxAnswerFile2);
 		answerFiles.addElement(this.checkBoxAnswerFile3);
 		answerFiles.addElement(this.checkBoxAnswerFile4);
 
 		return answerFiles;
 	}
 	
 	/** 
 	 * Returns a vector containing String representations 
 	 * of all of the image file locations. <br>
 	 * The first item is the first location, etc.
 	 *
 	 * @return Vector contains all of the image file locations if they exist 
 	 *                (locations are relative to the applets codebase)
 	 */
 	public Vector getAllImageFileLocations(){
 		
 		Vector imageFiles = new Vector(4);
 		
 		if(this.checkBoxImageAvailable){
 			imageFiles.addElement(this.checkBoxImage1);
 			imageFiles.addElement(this.checkBoxImage2);
 			imageFiles.addElement(this.checkBoxImage3);
 			imageFiles.addElement(this.checkBoxImage4);
 		}
 		
 		return imageFiles;
 	}
 	
 	/**
 	 * Returns a vector containing String representations 
 	 * of all of the text for each checkbox. <br>
 	 * The first item is the first text for the checkbox, etc.
 	 *
 	 * @return Vector contains all of the checkbox textual descriptions if they exist 
 	 */
 	public Vector getAllCheckBoxesText(){
 		
 		Vector checkboxText = new Vector(4);
 		
 		if(this.checkBoxTextAvailable){
 			checkboxText.addElement(this.checkBoxText1);
 			checkboxText.addElement(this.checkBoxText2);
 			checkboxText.addElement(this.checkBoxText3);
 			checkboxText.addElement(this.checkBoxText4);
 		} 		
 		return checkboxText;
 	}
 	
 	/** 
 	 * Allows the getting of the radiobuttons image file at location.
 	 * <br>
 	 * location should be from 1 to 4, returns null if otherwise.
 	 * 
 	 * @param location The number of the checkbox you want the image icon of (range 1 to 4)
 	 * @return ImageIcon the imageicon for the checkbox at location
 	 * @return null if the checkbox doesn't have an image icon
 	 */
 	public ImageIcon getCheckBoxImage(int location) {
 	
 		if(this.checkBoxImageAvailable){
 			if (location == 1) {
 				return this.checkBoxImage1;
 			}
 			else if (location == 2) {
 				return this.checkBoxImage2;	
 			}
 			else if (location == 3) {
 				return this.checkBoxImage3;	
 			}
 			else if (location == 4) {
 				return this.checkBoxImage4;	
 			}
 			else {
 				return null;
 			}
 		}
 		else {
 			return null;	
 		}
 	}
 	
 	/** 
 	 * Allows the getting of the checkbox at location's associated text
 	 * returns null if location is not between the range 1-4
 	 * 
 	 * @param location in range 1 to 4 indicating the checkbox you want the text of
 	 * @return String the textual description for the checkbox at location 
 	 * @return null if location not in range 1 to 4
 	 */
 	public String getCheckBoxText(int location) {
 	
		if (location == 1) {
			return this.checkBoxText1;
 		}
 		else if (location == 2) {	
 			return this.checkBoxText2;
 		}
  		else if (location == 3) {
 			return this.checkBoxText3;
 		}	
 		else if (location == 4) {
 			return this.checkBoxText4;
 		} 	
 		else {
 			return null;
 		}
 	}
 	
 	/** 
 	 * Allows the getting of the answer html page url of the checkbox at location
 	 * 
 	 * @param location the location of the checkbox that you want the html answer page of
 	 * @return String the location of the html answer page associated with the checkbox wanted (relative to the applets codebase)
 	 * @return null if location is not between the range 1-4
 	 */
 	public String getCheckBoxAnswerFile(int location) {
 	
		if (location == 1) {
			return this.checkBoxAnswerFile1;
 		}
 		else if (location == 2) {	
 			return this.checkBoxAnswerFile2;
 		}
  		else if (location == 3) {
 			return this.checkBoxAnswerFile3;
 		}	
 		else if (location == 4) {
 			return this.checkBoxAnswerFile4;
 		} 	
 		else {
 			return null;
 		}
 	}
 	
	//setter methods are provided for the use of the randomiser methods hence the reason for
	//them being private
	
	/** 
	 * Sets the checkbox text of checkbox at location to text.<br>
	 * if location does not refer to a valid checkbox (range 1 to 4) then it does nothing
	 *
	 * @param location The checkbox that you want to set the text of
	 * @param text TThe text you want to set it to
	 */
	private void setCheckBoxText(int location, String text) {
		if (location == 1) {
			this.checkBoxText1 = text;
 		}
 		else if (location == 2) {	
 			this.checkBoxText2 = text;
 		}
  		else if (location == 3) {
 			this.checkBoxText3 = text;
 		}	
 		else if (location == 4) {
 			this.checkBoxText4 = text;
 		} 	
	}
	
	/** 
	 * Sets the checkbox image of checkbox at location to image. <br>
	 * if location does not refer to a valid checkbox (range 1 to 4) then it does nothing
	 *
	 * @return location The checkbox that you want to set the image icon to
	 * @return image The image icon to associate with the checkbox at location
	 */
	private void setCheckBoxImage(int location, ImageIcon image) {
		if (location == 1) {
			this.checkBoxImage1 = image;
 		}
 		else if (location == 2) {	
 			this.checkBoxImage2 = image;
 		}
  		else if (location == 3) {
 			this.checkBoxImage3 = image;
 		}	
 		else if (location == 4) {
 			this.checkBoxImage4 = image;
 		} 	
	}
	
	/** 
	 * Sets the checkbox answerfile of checkbox at location to answerfile. <br>
	 * if location does not refer to a valid checkbox (range 1 to 4) then it does nothing.
	 * 
	 * @return location The checkbox location that you want to associate the answer html page to
	 * @return answerFile The html answer page location (relative to the applets codebase)
	 */
	private void setCheckBoxAnswerFile(int location, String answerFile) {
		if (location == 1) {
			this.checkBoxAnswerFile1 = answerFile;
 		}
 		else if (location == 2) {	
 			this.checkBoxAnswerFile2 = answerFile;
 		}
  		else if (location == 3) {
 			this.checkBoxAnswerFile3 = answerFile;
 		}	
 		else if (location == 4) {
 			this.checkBoxAnswerFile4 = answerFile;
 		} 	
	}
 }