import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;
import java.net.*;

/**
 * MultipleChoiceQuestions.java 1.0 22/12/12
 * <br><br>
 * Author       : James McMahon
 * <br><br>
 * Provides the editorpane where the html question pages can be displayed
 * <br><br>
 * Created      : 22/12/2002
 * <br>
 * Last Updated : 22/12/2002
 */
 
public class QuestionPanel extends JPanel {

	private String url = "";//url string
	private URL codeBase = null;
	private URL questionURL = null;//the url of the question page to be displayed
	private JEditorPane questionScreen= new JEditorPane(); //The Editor pane it is displayed upon

	private JLabel defaultLabel = new JLabel("Question HTML Pages should appear here", JLabel.CENTER);
	private JLabel missingPageLabel;
	private JLabel missingPageNameLabel;
	
	/** 
	 * initlises the JEditorPane making it uneditable and 
	 * setting the page displayed to the default Label
	 * N.B. The webpages are not navigatable!
	 * 
	 * @param codebase The codebase of the applet
	 */
	public QuestionPanel(URL codebase) {
		
		this.setLayout(new BorderLayout());
		this.setPreferredSize(new Dimension(150,150));
		this.setBorder(BorderFactory.createTitledBorder("Questions..."));
		codeBase = codebase;		
		
		questionScreen.setEditable(false);
		
		resetQuestionPanel();
		JScrollPane scroller = new JScrollPane(questionScreen);
		this.add(scroller, BorderLayout.CENTER);
		this.setVisible(true);
	
	}//End constructor
	
	/** 
	 * sets the editorpane to show the page pointed to by the answerpage url 
	 * 
	 * @param pageName The page name to be shown relative to the applet codebase
	 */
	public void setQuestionPage(String pageName){
			
		try {
			removeQuestionPanelLabel();//in case one exists
			
			url = codeBase+pageName;
			questionURL = new URL(url);
			questionScreen.setPage(questionURL);
					
		} catch(Exception ioe) { 
			//This is strange - if I catch the IOException that is supposed to be thrown then
			//it seems to ignore the actual exception that is generated - hence catch the general
			//case is the only why of ensuring that any problems will be caught
			
			//So got a problem here with trying to open the html page
			//So we will initilise the editor pane with an error message instead
			try {
				this.remove(questionScreen);
			}catch (NullPointerException npe){}

			this.add(missingPageLabel = new JLabel("A question page appears to be missing. Please contact the Course Lecturer"),BorderLayout.NORTH);
			this.add(missingPageNameLabel = new JLabel("The missing page is :"+pageName),BorderLayout.CENTER);	
		}
		
		this.setVisible(true);
		this.questionScreen.setVisible(true);
		this.validate();
		this.repaint();
	}

	/** 
	 * Resets the answerPanel to display the default answer label
	 */
	public void resetQuestionPanel(){

		try {
			this.remove(questionScreen);
		}catch (NullPointerException npe) {/*not on the panel to start with so do nothing*/}
	
		this.add(defaultLabel, BorderLayout.CENTER);
	}
	
	/** 
	 * Removes all the labels if possible
	 */
	public void removeQuestionPanelLabel(){

		try {
			this.remove(defaultLabel);
			this.remove(missingPageLabel);
			this.remove(missingPageNameLabel);
		}catch (NullPointerException npe) {/*not on the panel to start with so do nothing*/}
	}

	/** 
	 * Set the current question number displayed to questionNumber on the border 
	 *
	 * @param questionNumber The number of questions that have been asked (i.e. the current one is x out of totalx)
	 * @param totalAvailable The total number of questions available
	 */
	public void setQuestionNumber(int questionNumber, int totalAvailable) {
		this.setBorder(BorderFactory.createTitledBorder("Questions... Q"+questionNumber+" of "+totalAvailable));
	}
}