 import java.util.*;

 /**
 * MultipleChoiceQuestions.java 1.0 22/12/12
 * <br><br>
 * Author       : James McMahon
 * <br><br>
 * Encapsulates the questionSets for all the questions available to the applet
 * <br>
 * This allows access to each questionset of the applet
 * <br>
 * While QuestionSet allows access to specific questionSets and 
 * <br>     
 * QuestionData allows access to the specific question details 
 * <br><br>
 * Created      : 22/12/2002 
 * <br>
 * Last Updated : 22/12/2002
 */
 
 public class Questions {
 	
 	/** 
 	 * Contains all of the questionsets that are available in this applet incarnation<br>
 	 * This vector will only contain QuestionSets which in turn should contain QuestionData info
     */
 	private Vector questionSets;	
 	
 	/**
 	 * Constructor that initilises an empty Vector of questionSets
 	 */
 	public Questions(){
 		questionSets = new Vector(2);
 	} 	
 	
 	/** 
 	 * Adds questionSet to the set of all available data
 	 * 
 	 * @param questionSet The set that is to be added to the list of available questionsets
 	 */
 	public void addQuestionSet(QuestionSet questionSet){
 		this.questionSets.addElement(questionSet);
 	}
 	
 	/** 
 	 * Allows access to the number of questionSets available
 	 *
 	 * @return int The nuymber of questionSets containde in the set of all sets
 	 */
 	public int numberOfQuestionSets() {
 		return this.questionSets.size();	
 	}
 	
 	/** 
 	 * Allows access to a specific question set at location
 	 * between 0-n where n is the maximum question set available
 	 *
 	 * @param location The location of the question set that you want to get back
 	 * @return QuestionSet The questionset at location in the set of all questionsets
 	 */
 	public QuestionSet getQuestionSet(int location){
 		
 		if(location<=this.questionSets.size()) {
 			QuestionSet qSet = (QuestionSet) this.questionSets.elementAt(location);
 			qSet.randomise();
 			return qSet;
 		}
 		else {//Just return the last element available
 			return (QuestionSet) this.questionSets.lastElement();
 		}
 	}
 	
 	/** 
 	 * Returns the location of questionSet inside the set of allquestions <br>
 	 *
 	 * @param questionSet The question set you want to find the location of
 	 * @return -1 if the questionSet is not found
 	 * @return >0 is the location of the question set
 	 */
 	public int getQuestionSetLocation(QuestionSet questionSet){
 		return this.questionSets.indexOf(questionSet);	
 	}
 	
 	/** 
 	 * Get the question set names for the set selection
 	 * 
 	 * @return Object[] Contains the names of all of the question sets available
 	 */
 	public Object[] getQuestionSetNames() {
 		
 		Object nameArray[] = new Object[numberOfQuestionSets()];
 		int counter = 0;
 		Iterator itr = questionSets.iterator();
 		
 		while(itr.hasNext()) {
 			QuestionSet qSet = (QuestionSet) itr.next();
 
 			nameArray[counter] = ""+(counter+1)+": "+qSet.getQuestionSetName();
 			counter++;
 		} 
		//To show full list working - update the array size to 20
 		return nameArray;
 	}
 	
 	/**
 	 * Returns the first questionset found which is called questionSetName WHICH
 	 * is actually the name assigned to it from the getQuestionSetNames method.
 	 * <br>
 	 * This ensures that the names are all unique.
 	 * <br>
 	 * Unfortunately it means this is a more specific function than you might think.
 	 * <br><br>
 	 * DO NOT USE IT WITH ACTUAL QUESTION SET NAMES it won't work.
 	 * <br><br>
 	 * If the requested question set isn't found then the first question set available
 	 * is returned as a default.
 	 * <br>
 	 *
 	 * @param questionSetName The question set name you want to get returned (as detailed from getQuestionSetNames)
 	 * @return QuestionSet The question set you asked for if it was found (otherwise it returns the first one in the list)
 	 */
 	public QuestionSet getQuestionSet(String questionSetName) {
 		
 		int counter = 1;
 		Iterator itr = questionSets.iterator();
		
 		while(itr.hasNext()) {
 			QuestionSet qSet = (QuestionSet) itr.next();
				String compareName = ""+counter+": "+qSet.getQuestionSetName();
 			if (compareName.equals(questionSetName)) {
 				qSet.randomise();
 				return qSet;	
 			}
 			counter++;
 		}
 				
 		return (QuestionSet) questionSets.elementAt(0);
 	}
 }